<%@ Page language="c#" Codebehind="ActiveToDo.aspx.cs" AutoEventWireup="false" Inherits="Mediachase.UI.Web.Modules.ActiveToDo" %>
<%@ Register TagPrefix="ibn" TagName="BlockHeader" src="..\Modules\BlockHeader.ascx" %>
<%@ register TagPrefix="dg" namespace="Mediachase.UI.Web.Modules.DGExtension" Assembly="Mediachase.UI.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" > 

<html>
  <head>
    <title>Active ToDo</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script src="../Scripts/browser.js"></script>
		<script src="../Scripts/buttons.js"></script>		
		<LINK href="../layouts/styles/windows.css" type="text/css" rel="stylesheet">
		<link href="../Themes/<%=Mediachase.UI.Web.Util.CommonHelper.GetTheme()%>/theme.css" rel="stylesheet">
		<link href="../Themes/<%=Mediachase.UI.Web.Util.CommonHelper.GetTheme()%>/color1.css" rel="stylesheet">
		<script><!--
		if ((browseris.mac) && !browseris.ie5up)
		{
			var macstyle = "../layouts/styles/mac.css";
			document.write("<link rel='stylesheet' Type='text/css' href='" + macstyle + "'>");
		}
		//--></script>
  </head>
  <body class="UserBackground" id="pT_body" leftMargin="0" topMargin="0" marginwidth="0" marginheight="0">
    <form id="frmMain" runat="server">

<table cellpadding="0" cellspacing="0" width="100%" height="100%" style="margin-top:0; background-color:#E1ECFC">
	<tr>
		<td height="100%" style="padding:5px" valign="top">
			<dg:datagridextended id="dgActivities" runat="server" allowpaging="True" pagesize="10" allowsorting="True" cellpadding="1" gridlines="None" CellSpacing="0" borderwidth="0px" autogeneratecolumns="False" width="100%">
				<Columns>
					<asp:TemplateColumn SortExpression="Title">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%#
							Mediachase.UI.Web.Util.CommonHelper.GetTaskToDoLink 
							(
								(int)DataBinder.Eval(Container.DataItem, "ItemId"),
								(int)DataBinder.Eval(Container.DataItem, "IsToDo"),
								DataBinder.Eval(Container.DataItem, "Title").ToString(),
								(int)DataBinder.Eval(Container.DataItem, "StateId"),
								GetTarget()
							)
							%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn  SortExpression="ProjectTitle">
						<HeaderStyle CssClass="ibn-vh2"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2"></ItemStyle>
						<ItemTemplate>
							<%# DataBinder.Eval(Container.DataItem, "ProjectTitle")%>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="StartDate">
						<HeaderStyle CssClass="ibn-vh2" Width="95px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2" Width="95px"></ItemStyle>
						<ItemTemplate>
						<span runat="server"  Visible='<%#(bool)DataBinder.Eval(Container.DataItem,"ShowStartDate")%>' ID="Span3">
							<%# ((DateTime)DataBinder.Eval(Container.DataItem,"StartDate")).ToShortDateString()%></span>
						</ItemTemplate>
					</asp:TemplateColumn>
					<asp:TemplateColumn SortExpression="FinishDate">
						<HeaderStyle CssClass="ibn-vh2" Width="80px"></HeaderStyle>
						<ItemStyle CssClass="ibn-vb2" Width="80px"></ItemStyle>
						<ItemTemplate>
						<span runat="server" Visible='<%#(bool)DataBinder.Eval(Container.DataItem,"ShowFinishDate")%>' ID="Span4">
							<%# ((DateTime)DataBinder.Eval(Container.DataItem,"FinishDate")).ToShortDateString()%></span>
						</ItemTemplate>
					</asp:TemplateColumn>
				</Columns>
			</dg:datagridextended>
		</td>
	</tr>
</table>
    </form>
  </body>
</html>
